import { readdirSync } from 'node:fs';
const files = readdirSync('./apis', { recursive: true });
// 接口映射对象
const apiMaps = {};
for (let file of files) {
    if (file.endsWith('.js')) {
        apiMaps[file.replace('.js', '').replace(/\\+/, '/')] = await import(`./apis/${file}`);
    }
}

export { apiMaps };
