import { mysqlPool } from '../../mysql.js';
import { ajvValid } from '../../utils.js';

export const apiSchema = {
    // 元数据
    meta: {
        tags: ['文章'],
        summary: '删除文章'
    },
    // 请求协议
    request: {
        type: 'object',
        properties: {
            id: {
                type: 'integer',
                title: 'ID',
                minimum: 1
            },
            author: {
                type: 'integer',
                title: '作者',
                minimum: 1
            }
        },
        required: ['id', 'author'],
        additionalProperties: false
    }
};

export default async (req) => {
    try {
        await ajvValid(apiSchema.request, req.body);
        // ------------------------------------------------------
        // 从连接池中获取一个数据库连接
        const db = await mysqlPool.getConnection();
        // 查询数据库是否有对应的用户数据
        const [result] = await db.query({
            sql: 'DELETE FROM `article` WHERE `id` = :id AND `author` = :author',
            values: {
                id: Number(req.body.id),
                author: Number(req.body.author)
            }
        });
        // 释放数据库连接
        db.release();
        // 返回成功信息
        return {
            code: 0,
            msg: '删除文章成功',
            data: {}
        };
    } catch (err) {
        console.log('🚀 ~ err:', err);
        return {
            code: 1,
            msg: '未知错误'
        };
    }
};
