import Ajv from 'ajv';
import localize from 'ajv-i18n';
const ajv = new Ajv({ allErrors: true, messages: true });

// 参数验证
export const ajvValid = (schema, data) => {
    return new Promise((resolve, reject) => {
        const validate = ajv.compile(schema);
        const valid = validate(data);
        if (!valid) {
            localize.zh(validate.errors);

            reject({ from: 'ajv', data: ajv.errorsText(validate.errors, { separator: '\n' }) });
        } else {
            resolve();
        }
    });
};
