import { mysqlPool } from '../../mysql.js';
import { ajvValid } from '../../utils.js';

export const apiSchema = {
    // 元数据
    meta: {
        tags: ['文章'],
        summary: '文章详情'
    },
    // 请求协议
    request: {
        type: 'object',
        properties: {
            id: {
                type: 'integer',
                title: '文章ID',
                minimum: 1
            }
        },
        required: ['id'],
        additionalProperties: false
    }
};

export default async (req) => {
    try {
        await ajvValid(apiSchema.request, req.body);

        // ------------------------------------------------------
        // 从连接池中获取一个数据库连接
        const db = await mysqlPool.getConnection();
        // 查询数据库是否有对应的用户数据
        const [rows] = await db.query({
            sql: 'SELECT * FROM `article` WHERE `id` = :id LIMIT 1',
            values: {
                id: Number(req.body.id)
            }
        });
        // 释放数据库连接
        db.release();
        // 返回成功信息
        return {
            code: 0,
            msg: '查询文章详情成功',
            data: rows?.[0] || {}
        };
    } catch (err) {
        console.log('🚀 ~ err:', err);
        return {
            code: 1,
            msg: '未知错误'
        };
    }
};
