import { mysqlPool } from '../../mysql.js';
import { ajvValid } from '../../utils.js';

export const apiSchema = {
    // 元数据
    meta: {
        tags: ['文章'],
        summary: '查询文章'
    },
    // 请求协议
    request: {
        type: 'object',
        properties: {
            page: {
                type: 'integer',
                title: '用户名',
                minimum: 1
            },
            limit: {
                type: 'integer',
                title: '密码',
                minimum: 1,
                maximum: 100
            },
            author: {
                type: 'integer',
                title: '作者',
                minimum: 1
            }
        },
        required: ['page', 'limit', 'author'],
        additionalProperties: false
    }
};

export default async (req) => {
    try {
        await ajvValid(apiSchema.request, req.body);

        // ------------------------------------------------------
        // 从连接池中获取一个数据库连接
        const db = await mysqlPool.getConnection();
        // 查询数据总数
        const [[{ total }]] = await db.query({
            sql: 'SELECT COUNT(`id`) as total FROM `article` WHERE `author` = :author',
            values: {
                author: Number(req.body.author)
            }
        });
        // 查询数据库是否有对应的用户数据
        const [rows] = await db.query({
            sql: 'SELECT * FROM `article` WHERE `author` = :author LIMIT :offset,:limit',
            values: {
                offset: (Number(req.body.page) - 1) * Number(req.body.limit),
                limit: Number(req.body.limit),
                author: Number(req.body.author)
            }
        });
        // 释放数据库连接
        db.release();
        // 返回成功信息
        return {
            code: 0,
            msg: '查询文章成功',
            data: rows || [],
            total: total
        };
    } catch (err) {
        console.log('🚀 ~ err:', err);
        return {
            code: 1,
            msg: '未知错误'
        };
    }
};
