import { mysqlPool } from '../../mysql.js';
import { ajvValid } from '../../utils.js';

export const apiSchema = {
    // 元数据
    meta: {
        tags: ['文章'],
        summary: '更新文章'
    },
    // 请求协议
    request: {
        type: 'object',
        properties: {
            id: {
                type: 'integer',
                title: '文章ID',
                minimum: 1
            },
            title: {
                type: 'string',
                title: '用户名',
                minLength: 1,
                maxLength: 100
            },
            content: {
                type: 'string',
                title: '密码',
                minLength: 1,
                maxLength: 50000
            },
            author: {
                type: 'integer',
                title: '作者',
                minimum: 1
            }
        },
        required: ['id', 'title', 'content', 'author'],
        additionalProperties: false
    }
};
export default async (req) => {
    try {
        await ajvValid(apiSchema.request, req.body);

        // ------------------------------------------------------
        // 从连接池中获取一个数据库连接
        const db = await mysqlPool.getConnection();
        // 查询数据库是否有对应的用户数据
        const [result] = await db.query({
            sql: 'UPDATE `article` SET `title` = :title,`content` = :content,`updated_at` = :updated_at WHERE `id` = :id AND `author` = :author',
            values: {
                id: req.body.id,
                title: req.body.title,
                content: req.body.content,
                author: Number(req.body.author),
                updated_at: Date.now()
            }
        });
        // 释放数据库连接
        db.release();
        // 返回成功信息
        return {
            code: 0,
            msg: '修改文章成功'
        };
    } catch (err) {
        console.log('🚀 ~ err:', err);
        return {
            code: 1,
            msg: '未知错误'
        };
    }
};
