import { readdirSync, writeFileSync } from 'node:fs';
const files = readdirSync('./apis', { recursive: true });

const apiTemplate = {
    openapi: '3.0.0',
    info: {
        title: 'CoolApi接口文档',
        version: '1.0.0'
    },
    paths: {}
};
// 接口映射对象
const apiPaths = {};
for (let file of files) {
    if (file.endsWith('.js')) {
        const { apiSchema } = await import(`./apis/${file}`);
        if (apiSchema) {
            apiPaths['/' + file.replace('.js', '').replace(/\\+/, '/')] = {
                post: {
                    tags: apiSchema?.meta?.tags,
                    summary: apiSchema?.meta?.summary,
                    requestBody: {
                        required: true,
                        content: {
                            'application/json': {
                                schema: apiSchema?.request || {}
                            }
                        }
                    },
                    responses: {
                        200: {
                            description: '操作成功',
                            content: {
                                'application/json': {
                                    schema: {}
                                }
                            }
                        }
                    }
                }
            };
        }
    }
}

apiTemplate.paths = apiPaths;

writeFileSync('./apis.json', JSON.stringify(apiTemplate));
