// 查询文章详情
const apiArticleDetail = async (action) => {
    // 解析地址栏参数
    const searchParams = new URLSearchParams(window.location.search);
    // 获取解析后的参数中字段为id的值
    const id = Number(searchParams.get('id'));
    // 根据文章ID请求对应的内容
    const { code, data, msg } = await utilHttp('/api/article/detail', {
        id: id
    });

    // 判断 code 是否等于0，为0则表示拿到了正常的接口数据
    if (code === 0) {
        // 时间格式
        data.created_at2 = utilTimestampToYMD(data.created_at);
        data.updated_at2 = utilTimestampToYMD(data.updated_at);

        // 把数据用模板渲染
        const html = template('article-detail', {
            data: data
        });
        // 把渲染后的数据放到页面中
        document.querySelector('.inner').innerHTML = html;
    } else {
        // 否则在控制台显示接口异常提示
        utilShowMsg(msg);
    }
};

apiArticleDetail();
