import { mysqlPool } from '../../mysql.js';
export default async (req) => {
    try {
        const id = req.body.id;
        // ------------------------------------------------------
        if (/[1-9]\d*/.test(id) === false) {
            return {
                code: 1,
                msg: '文档ID必须为非0正整数'
            };
        }

        // ------------------------------------------------------
        // 从连接池中获取一个数据库连接
        const db = await mysqlPool.getConnection();
        // 查询数据库是否有对应的用户数据
        const [rows] = await db.query({
            sql: 'SELECT * FROM `article` WHERE `id` = :id LIMIT 1',
            values: {
                id: Number(id)
            }
        });
        // 释放数据库连接
        db.release();
        // 返回成功信息
        return {
            code: 0,
            msg: '查询文章详情成功',
            data: rows?.[0] || {}
        };
    } catch (err) {
        console.log('🚀 ~ err:', err);
        return {
            code: 1,
            msg: '未知错误'
        };
    }
};
