// 请求封装
const utilHttp = async (url, data, action = 'common') => {
    // 初始化参数
    const params = {
        method: 'POST',
        headers: {}
    };
    // 普通请求
    if (action === 'common') {
        params.headers['Content-Type'] = 'application/json;charset=utf-8';
        params.body = JSON.stringify(data);
    }
    // 上传文件
    if (action === 'upload') {
        const formData = new FormData();
        formData.append('file', data);
        params.body = formData;
    }

    // 收到的返回值
    const response = await fetch(url, params);
    // 把拿到的数据变成JSON结构
    const result = await response.json();
    return result;
};

// 时间戳转年月日
const utilTimestampToYMD = (timestamp) => {
    if (!timestamp) return '';
    const date = new Date(timestamp);
    const year = date.getFullYear();
    const month = ('0' + (date.getMonth() + 1)).slice(-2); // 月份从 0 开始，所以要加 1
    const day = ('0' + date.getDate()).slice(-2);
    const hours = ('0' + date.getHours()).slice(-2);
    const minutes = ('0' + date.getMinutes()).slice(-2);

    return `${year}-${month}-${day} ${hours}:${minutes}`;
};

// 显示弹框
const utilShowMsg = (msg, fn) => {
    const alertBox = document.createElement('div');
    alertBox.textContent = msg;
    alertBox.style.cssText = `
    position: fixed;
    top: 100px;
    left: 50%;
    transform: translate(-50%, -50px);
    background-color: rgba(0, 0, 0, 0.8);
    color: #fff;
    padding: 20px;
    border-radius: 5px;
    text-align: center;
    z-index: 1000;
  `;
    document.body.appendChild(alertBox);

    setTimeout(() => {
        alertBox.remove();
        if (fn) {
            fn();
        }
    }, 2000);
};
