import { writeFileSync } from 'node:fs';
import { extname } from 'node:path';
export default async (req) => {
    return new Promise((resolve, reject) => {
        let body = [];
        req.on('data', (chunk) => {
            body.push(chunk);
        }).on('end', () => {
            try {
                body = Buffer.concat(body);
                const contentType = req.headers['content-type'];
                const boundary = contentType.split('; ')[1].split('=')[1];
                // 查找文件数据的起始和结束位置
                const fileDataStart = body.indexOf(`\r\n\r\n`, body.indexOf(`Content-Type:`)) + 4;
                const fileDataEnd = body.indexOf(`\r\n--${boundary}--`) - 2;
                const fileExt = extname(
                    body
                        .slice(0, fileDataStart)
                        .toString()
                        ?.match(/filename="(.+?)"/)?.[1] || ''
                );
                // 提取文件数据
                const fileData = body.slice(fileDataStart, fileDataEnd);
                const fileName = Date.now() + fileExt;
                // 写入文件
                writeFileSync(`./public/uploads/${fileName}`, fileData);
                resolve({
                    code: 0,
                    data: {
                        fileName: fileName
                    },
                    msg: '文件上传成功'
                });
            } catch (err) {
                console.log('🚀 ~ req.on ~ err:', err);
                resolve({
                    code: 1,
                    msg: '文件上传失败'
                });
            }
        });
    });
};
