import { mysqlPool } from '../../mysql.js';
export default async (req) => {
    try {
        // 参数去掉前后空格
        const username = req.body.username.trim();
        const password = req.body.password.trim();
        // ------------------------------------------------------
        // 验证用户名参数
        if (username.length < 2) {
            return {
                code: 1,
                msg: '用户名太短'
            };
        }
        // ------------------------------------------------------
        // 验证密码参数
        if (password.length < 6) {
            return {
                code: 1,
                msg: '密码太短'
            };
        }
        // ------------------------------------------------------
        // 从连接池中获取一个数据库连接
        const db = await mysqlPool.getConnection();
        // 查询数据库是否有对应的用户数据
        const [rows] = await db.query({
            sql: 'SELECT * FROM `user` WHERE `username`=:username LIMIT 1',
            values: {
                username: username
            }
        });
        // ------------------------------------------------------
        // 如果查到了用户数据，说明该用户名已注册
        if (rows.length <= 0) {
            return {
                code: 1,
                msg: '用户未注册'
            };
        }
        // ------------------------------------------------------
        // 判断密码是否匹配
        const [user] = rows; // rows是一个数组，我们这里用user变量去取数组的第一个值
        if (user.password !== password) {
            return {
                code: 1,
                msg: '密码错误'
            };
        }
        // 释放数据库连接
        db.release();
        // 返回成功信息
        return {
            code: 0,
            msg: '登录成功',
            data: user
        };
    } catch (err) {
        console.log('🚀 ~ err:', err);
        return {
            code: 1,
            msg: '未知错误'
        };
    }
};
