import { mysqlPool } from '../../mysql.js';
export default async (req) => {
    try {
        // 从连接池中获取一个数据库连接
        const db = await mysqlPool.getConnection();
        // 查询数据库是否有对应的用户数据
        const result = await db.query({
            sql: 'SELECT VERSION()'
        });
        console.log('🚀 ~ result:', result);
        // 释放数据库连接
        db.release();
        // 返回成功信息
        return {
            code: 0,
            msg: '注册成功'
        };
    } catch (err) {
        console.log('🚀 ~ err:', err);
        return {
            code: 1,
            msg: '未知错误'
        };
    }
};
