import { mysqlPool } from '../../mysql.js';
export default async (req) => {
    try {
        // 参数去掉前后空格
        const page = req.body.page; // 第几页
        const limit = req.body.limit; // 每页多少条
        const author = req.body.author; // 查谁的
        // ------------------------------------------------------
        // 验证标题参数
        // 验证作者参数，必须为非0数字开头的整数
        if (/[1-9]\d*/.test(page) === false) {
            return {
                code: 1,
                msg: '当前页码必须为非0正整数'
            };
        }

        // ------------------------------------------------------
        // 验证内容参数
        // 验证作者参数，必须为非0数字开头的整数
        if (/[1-9]\d*/.test(limit) === false) {
            return {
                code: 1,
                msg: '每页条数必须为非0正整数'
            };
        }
        // ------------------------------------------------------
        // 验证作者参数，必须为非0数字开头的整数
        if (/[1-9]\d*/.test(author) === false) {
            return {
                code: 1,
                msg: '文章作者必须传作者的数字ID'
            };
        }
        // ------------------------------------------------------
        // 从连接池中获取一个数据库连接
        const db = await mysqlPool.getConnection();
        // 查询数据总数
        const [[{ total }]] = await db.query({
            sql: 'SELECT COUNT(`id`) as total FROM `article` WHERE `author` = :author',
            values: {
                author: Number(author)
            }
        });
        // 查询数据库是否有对应的用户数据
        const [rows] = await db.query({
            sql: 'SELECT * FROM `article` WHERE `author` = :author LIMIT :offset,:limit',
            values: {
                offset: (Number(page) - 1) * Number(limit),
                limit: Number(limit),
                author: Number(author)
            }
        });
        // 释放数据库连接
        db.release();
        // 返回成功信息
        return {
            code: 0,
            msg: '查询文章成功',
            data: rows || [],
            total: total
        };
    } catch (err) {
        console.log('🚀 ~ err:', err);
        return {
            code: 1,
            msg: '未知错误'
        };
    }
};
