import { mysqlPool } from '../../mysql.js';
export default async (req) => {
    try {
        // 参数去掉前后空格
        const id = req.body.id;
        const title = req.body.title.trim();
        const content = req.body.content.trim();
        const author = req.body.author;
        // ------------------------------------------------------
        // 验证ID参数
        if (/[1-9]\d*/.test(id) === false) {
            return {
                code: 1,
                msg: '文章ID必须为非0正整数'
            };
        }

        // ------------------------------------------------------
        // 验证标题参数
        if (title.length < 1 || title.length > 100) {
            return {
                code: 1,
                msg: '文章标题长度不能小于1，不能大于100'
            };
        }

        // ------------------------------------------------------
        // 验证内容参数
        if (content.length < 1 || content.length > 60000) {
            return {
                code: 1,
                msg: '文章内容长度不能小于1，不能大于6000'
            };
        }

        // ------------------------------------------------------
        // 验证作者参数，必须为非0数字开头的整数
        if (/[1-9]\d*/.test(author) === false) {
            return {
                code: 1,
                msg: '文章作者必须传作者的数字ID'
            };
        }

        // ------------------------------------------------------
        // 从连接池中获取一个数据库连接
        const db = await mysqlPool.getConnection();
        // 查询数据库是否有对应的用户数据
        const [result] = await db.query({
            sql: 'UPDATE `article` SET `title` = :title,`content` = :content,`updated_at` = :updated_at WHERE `id` = :id AND `author` = :author',
            values: {
                id: id,
                title: title,
                content: content,
                author: Number(author),
                updated_at: Date.now()
            }
        });
        // 释放数据库连接
        db.release();
        // 返回成功信息
        return {
            code: 0,
            msg: '修改文章成功'
        };
    } catch (err) {
        console.log('🚀 ~ err:', err);
        return {
            code: 1,
            msg: '未知错误'
        };
    }
};
