// 查询文章列表
const apiArticleSelect = async (page = 1) => {
    // 获取登录时保存到本地的用户数据，并解析成对象结构
    const user = JSON.parse(localStorage.getItem('user'));
    document.querySelector('.author').innerText = user.username;
    // 请求查询接口，拿到文章列表
    const { code, data, total, msg } = await utilHttp('/api/article/select', {
        page: page,
        limit: 15,
        author: user.id
    });
    // 判断 code 是否等于0，为0则表示拿到了正常的接口数据
    if (code === 0) {
        // 处理日期，把时间戳转为年月日，并用新字段保存
        const data2 = data.map((item) => {
            item.created_at2 = utilTimestampToYMD(item.created_at);
            item.updated_at2 = utilTimestampToYMD(item.updated_at);
            return item;
        });

        // 把数据用模板渲染
        const html = template('article-lists', {
            data: data2
        });
        // 把渲染后的数据放到页面中
        document.querySelector('.panel').innerHTML = html;

        // 分页数据相关
        document.querySelector('.page .num').innerText = page;
        document.querySelector('.page .pages .value').innerText = Math.ceil(total / 15);
        document.querySelector('.page .total .value').innerText = total;
    }
};

// 直接运行文章查询接口
apiArticleSelect();

// 点击添加文章按钮
document.querySelector('.insert').addEventListener('click', async () => {
    const title = document.querySelector('.form .title').value;
    const content = document.querySelector('.form .content').value;
    // 获取登录时保存到本地的用户数据，并解析成对象结构
    const user = JSON.parse(localStorage.getItem('user'));
    // 把拿到的数据变成JSON结构
    const { code, data, msg } = await utilHttp('/api/article/insert', {
        title: title,
        content: content,
        author: user.id
    });
    utilShowMsg(msg);
    if (code === 0) {
        apiArticleSelect();
    }
});

// 保存当前操作的文章ID
let updateId = 0;
// 点击更新文章按钮，把内容放到输入框中
document.querySelector('.panel').addEventListener('click', async (evt) => {
    if (evt.target.className === 'upd') {
        updateId = evt.target.dataset.id;
        const tr = evt.target.closest('.tr'); // 当前行
        const title = tr.querySelector('.title').innerText; // 当前行标题
        const content = tr.querySelector('.content').innerText; // 当前行内容
        document.querySelector('.form .title').value = title;
        document.querySelector('.form .content').value = content;
    }
});
// 点击更新文章按钮
document.querySelector('.update').addEventListener('click', async () => {
    const title = document.querySelector('.form .title').value;
    const content = document.querySelector('.form .content').value;
    // 获取登录时保存到本地的用户数据，并解析成对象结构
    const user = JSON.parse(localStorage.getItem('user'));
    // 把拿到的数据变成JSON结构
    const { code, data, msg } = await utilHttp('/api/article/update', {
        title: title,
        content: content,
        author: user.id,
        id: updateId
    });
    utilShowMsg(msg);
    if (code === 0) {
        apiArticleSelect();
    }
});

// 点击删除文章按钮
document.querySelector('.panel').addEventListener('click', async (evt) => {
    if (evt.target.className === 'del') {
        const user = JSON.parse(localStorage.getItem('user'));
        const id = evt.target.dataset.id;
        // 把拿到的数据变成JSON结构
        const { code, data, msg } = await utilHttp('/api/article/delete', {
            id: id,
            author: user.id
        });
        utilShowMsg(msg);
        if (code === 0) {
            apiArticleSelect();
        }
    }
});

// 点击上一页
document.querySelector('.page .prev').addEventListener('click', async (evt) => {
    const num = Number(document.querySelector('.page .num').innerText);
    if (num > 1) {
        apiArticleSelect(num - 1);
    }
});

// 点击下一页
document.querySelector('.page .next').addEventListener('click', async (evt) => {
    const num = Number(document.querySelector('.page .num').innerText);
    const pages = Number(document.querySelector('.page .pages .value').innerText);
    if (num < pages) {
        apiArticleSelect(num + 1);
    }
});
