// 查询文章列表
const apiArticleSelect = async (action) => {
    let page = Number(document.getElementById('curr').innerText);
    if (action === 'next') {
        page += 1;
    }
    if (action === 'prev') {
        if (page > 1) page -= 1;
    }
    // 获取登录时保存到本地的用户数据，并解析成对象结构
    const user = JSON.parse(localStorage.getItem('user'));
    // 请求查询接口，拿到文章列表
    const { code, data, msg, total } = await utilHttp('/api/article/select', {
        page: page,
        limit: 10,
        author: user.id
    });

    // 判断 code 是否等于0，为0则表示拿到了正常的接口数据
    if (code === 0) {
        document.getElementById('total1').innerText = Math.ceil(total / 10);
        document.getElementById('total').innerText = total;

        // 只有返回数据的时候，才改变当前页码，否则当前页面不变
        if (data.length > 0) {
            // 处理日期，把时间戳转为年月日，并用新字段保存
            const data2 = data.map((item) => {
                item.created_at2 = utilTimestampToYMD(item.created_at);
                item.updated_at2 = utilTimestampToYMD(item.updated_at);
                return item;
            });

            // 把数据用模板渲染
            const html = template('article-lists', {
                data: data2
            });
            // 把渲染后的数据放到页面中
            document.querySelector('.lists').innerHTML = html;
            document.getElementById('curr').innerText = page;
        } else {
            if (action === 'next') {
                document.getElementById('curr').innerText = page - 1;
            }
        }
    } else {
        // 否则在控制台显示接口异常提示
        utilShowMsg(msg);
    }
};

// 点击下一页
document.querySelector('.next').addEventListener('click', async () => {
    apiArticleSelect('next');
});
// 点击上一页
document.querySelector('.prev').addEventListener('click', async () => {
    apiArticleSelect('prev');
});

// 直接运行文章查询接口
apiArticleSelect();
