import { mysqlPool } from '../../mysql.js';
export default async (req) => {
    try {
        // 接收参数
        const id = req.body.id;
        const author = req.body.author;
        // ------------------------------------------------------
        // 验证ID参数
        if (/[1-9]\d*/.test(id) === false) {
            return {
                code: 1,
                msg: '文章ID必须为非0正整数'
            };
        }

        // ------------------------------------------------------
        // 验证作者参数，必须为非0数字开头的整数
        if (/[1-9]\d*/.test(author) === false) {
            return {
                code: 1,
                msg: '文章作者必须传作者的数字ID'
            };
        }
        // ------------------------------------------------------
        // 从连接池中获取一个数据库连接
        const db = await mysqlPool.getConnection();
        // 查询数据库是否有对应的用户数据
        const [result] = await db.query({
            sql: 'DELETE FROM `article` WHERE `id` = :id AND `author` = :author',
            values: {
                id: Number(id),
                author: Number(author)
            }
        });
        console.log('🚀 ~ result:', result);
        // 释放数据库连接
        db.release();
        // 返回成功信息
        return {
            code: 0,
            msg: '删除文章成功',
            data: {}
        };
    } catch (err) {
        console.log('🚀 ~ err:', err);
        return {
            code: 1,
            msg: '未知错误'
        };
    }
};
