import { createServer } from 'node:http';
import { readFileSync, existsSync } from 'node:fs';
import { lookup } from 'mime-types';
import { apiMaps } from './routes.js';

const server = createServer((req, res) => {
    if (req.url.startsWith('/api/') === true) {
        const apiName = req.url.replace('/api/', '');
        res.setHeader('Content-Type', 'application/json');
        if (apiMaps[apiName]) {
            let body = '';
            req.on('data', (chunk) => {
                body += chunk.toString();
            });
            req.on('end', async () => {
                try {
                    req.body = JSON.parse(body);
                    const result = await apiMaps[apiName].default(req);
                    res.end(JSON.stringify(result));
                } catch (err) {
                    console.log('🚀 ~ req.on ~ err:', err);
                    res.end(
                        JSON.stringify({
                            code: 1,
                            msg: '请求参数结构有误'
                        })
                    );
                }
            });
        } else {
            res.end(
                JSON.stringify({
                    code: 1,
                    msg: '接口不存在'
                })
            );
        }
    } else {
        // 如果是资源
        let staticFile = req.url.split('?')?.[0] || '';
        if (staticFile === '/') {
            staticFile = '/index.html';
        }
        if (existsSync(`./public/${staticFile}`) === true) {
            res.setHeader('Content-Type', lookup(staticFile));
            res.end(readFileSync(`./public/${staticFile}`));
        } else {
            res.writeHead(404, { 'Content-Type': 'text/plain' });
            res.end('404 Not Found');
        }
    }
});

server.listen(3000, '127.0.0.1', () => {
    console.log('服务已启动，监听端口为：3000');
});
